import * as WS from './core/websocket.js';
import * as PPT from './modules/ppt.js';
import * as Live from './modules/live.js';
import * as Image from './modules/image.js';
import * as Drawing from './modules/drawing.js';
import { els } from './modules/ui.js';

// Expose to window for HTML onClick handlers (temporary bridge)
window.sendCommand = PPT.sendCommand;
window.toggleLive = Live.toggleLive;
window.stopLive = Live.stopLive;
window.triggerUpload = Image.triggerUpload;
window.controlImage = Image.controlImage;
window.closeImageView = Image.closeImageView;
// Namespace for repairs
window.app = { sendCommand: PPT.sendCommand };
window.toggleDrawing = Drawing.toggleDrawing;
window.saveDrawing = Drawing.saveDrawing;

// Initialize
document.addEventListener('DOMContentLoaded', () => {
    WS.connect();
    
    WS.on('open', () => {
        if (els.statusInd) els.statusInd.classList.add('status-connected');
        if (els.loadingEl) els.loadingEl.innerText = '正在获取画面...';
        if (els.playStatusEl) {
            els.playStatusEl.classList.remove('disconnected');
            els.playStatusEl.innerText = '连接中...';
        }
    });

    WS.on('message', (msg) => {
        if (msg.type === 'update') {
            PPT.handleUpdate(msg);
        } else if (msg.type === 'stop_live') {
            Live.stopLive(true);
        }
    });

    WS.on('close', () => {
        if (els.statusInd) els.statusInd.classList.remove('status-connected');
        if (els.playStatusEl) {
            els.playStatusEl.innerText = '已断开';
            els.playStatusEl.classList.add('disconnected');
        }
        if (els.loadingEl) {
            els.loadingEl.style.display = 'block';
            els.loadingEl.innerText = '连接断开，尝试重连...';
        }
    });
    
    // Init modules
    PPT.initPPT();
    Image.initImageControl();
    Drawing.initDrawing();

    // Bind color picker
    if (els.colorDots) {
        els.colorDots.forEach(dot => {
            dot.addEventListener('click', (e) => {
                const color = e.target.dataset.color;
                if (color) {
                    Drawing.setPen(color);
                    // Update UI
                    els.colorDots.forEach(d => d.classList.remove('active'));
                    if (els.btnEraser) els.btnEraser.classList.remove('btn-active');
                    
                    // Handle click on dot or inner element
                    const target = e.target.classList.contains('color-dot') ? e.target : e.target.closest('.color-dot');
                    if (target) target.classList.add('active');
                }
            });
        });
    }

    // Bind Eraser
    if (els.btnEraser) {
        els.btnEraser.addEventListener('click', () => {
            Drawing.setPen('eraser');
            // Update UI
            els.colorDots.forEach(d => d.classList.remove('active'));
            els.btnEraser.classList.add('btn-active');
        });
    }
});
