export const els = {
    statusInd: document.getElementById('status-indicator'),
    imgEl: document.getElementById('preview-img'),
    loadingEl: document.getElementById('loading-text'),
    pageInfoEl: document.getElementById('page-info'),
    stripEl: document.getElementById('slide-strip-container'),
    playStatusEl: document.getElementById('play-status'),
    appTypeEl: document.getElementById('app-type-badge'),
    previewContainer: document.getElementById('preview-container'),
    feedbackLeft: document.getElementById('feedback-left'),
    feedbackRight: document.getElementById('feedback-right'),
    loadingOverlay: document.getElementById('loading-overlay'),
    loadingOverlayText: document.getElementById('loading-overlay-text'),
    // Live elements
    liveOverlay: document.getElementById('live-overlay'),
    videoEl: document.getElementById('live-video'),
    canvasEl: document.getElementById('live-canvas'),
    btnLive: document.getElementById('btn-live'),
    // Image view elements
    imageViewOverlay: document.getElementById('image-view-overlay'),
    viewImg: document.getElementById('view-img'),
    gestureArea: document.getElementById('gesture-area'),
    fileUpload: document.getElementById('file-upload'),
    btnUpload: document.getElementById('btn-upload'),
    btnDraw: document.getElementById('btn-draw'),
    btnEraser: document.getElementById('btn-eraser'),
    btnSave: document.getElementById('btn-save'),
    lockInd: document.getElementById('lock-indicator'),
    colorPicker: document.getElementById('color-picker'),
    colorDots: document.querySelectorAll('.color-dot')
};

export function showFeedback(el) {
    if (!el) return;
    el.classList.add('active');
    setTimeout(() => {
        el.classList.remove('active');
    }, 200);
}

export function showLoading(text) {
    if (!els.loadingOverlay) return;
    els.loadingOverlayText.innerText = text;
    els.loadingOverlay.style.display = 'flex';
    els.loadingOverlay.style.opacity = '1';
}

export function hideLoading() {
    if (!els.loadingOverlay) return;
    els.loadingOverlay.style.opacity = '0';
    setTimeout(() => els.loadingOverlay.style.display = 'none', 300);
}
